/*
 * Decompiled with CFR 0.152.
 */
package jade.core.management;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JarClassLoader
extends ClassLoader {
    public static final int BUFFER_SIZE = 1024;
    private JarFile _file = null;

    public JarClassLoader(File f, ClassLoader parent) throws IOException {
        super(parent);
        if (f != null) {
            this._file = new JarFile(f);
        }
    }

    public void close() throws IOException {
        if (this._file != null) {
            this._file.close();
        }
    }

    protected Class findClass(String className) throws ClassNotFoundException {
        if (this._file != null) {
            ZipEntry zEntry = this._file.getEntry(className.replace('.', '/') + ".class");
            try {
                InputStream is = this._file.getInputStream(zEntry);
                byte[] rawClass = this.readFully(is);
                is.close();
                return this.defineClass(className, rawClass, 0, rawClass.length);
            }
            catch (IOException ioe) {
                throw new ClassNotFoundException("IOError while reading jar file for class " + className + ". " + ioe);
            }
        }
        throw new ClassNotFoundException(className);
    }

    private byte[] readFully(InputStream is) throws IOException {
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int read = 0;
        while ((read = is.read(buffer)) >= 0) {
            baos.write(buffer, 0, read);
        }
        return baos.toByteArray();
    }
}

